/*
 * Copyright (C) Jan 2006 Mellanox Technologies Ltd. All rights reserved.
 *
 * This software is available to you under a choice of one of two
 * licenses.  You may choose to be licensed under the terms of the GNU
 * General Public License (GPL) Version 2, available from the file
 * COPYING in the main directory of this source tree, or the
 * OpenIB.org BSD license below:
 *
 *     Redistribution and use in source and binary forms, with or
 *     without modification, are permitted provided that the following
 *     conditions are met:
 *
 *      - Redistributions of source code must retain the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer.
 *
 *      - Redistributions in binary form must reproduce the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer in the documentation and/or other materials
 *        provided with the distribution.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 *  IniFile.cpp - Ini-file parsing class
 *
 *  Version: $Id: IniFile.cpp 2752 2006-01-19 14:40:17Z mst $
 *
 */
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>

#include <string>
#include <iostream>
#include <fstream>

#include "IniFile.h"
#include "utils.h"

namespace std {}; using namespace std;

////////////////////////////////////////////////////////////////////////
bool IniFile::parse(const char *fname)
{
    _fname = (char *)fname;

    ifstream fp(fname);
    if (!fp)
        return errmsg("Can't open INI file \"%s\": %s", fname, strerror(errno));

    string rbuf;
    for (_line=1; getline(fp, rbuf); _line++)
    {
        // Remove \r
        int n;
        while ( (n=rbuf.find('\r')) != -1)
            rbuf.erase(n);

        // Skip leading spaces
        n = rbuf.find_first_not_of(" \t");
        if (n != -1)
            rbuf.erase(0, n);

        // Skip comments and empty lines
        if (rbuf[0] == '#'  ||  rbuf[0] == ';')
            continue;
        if (rbuf.empty())
            continue;

        if (rbuf[0] == '[')
        {
            // Group
            n = rbuf.find(']');
            if (n == -1)
                return errmsg("File: %s, Line: %d - Invalid syntax (group name).",
                              _fname, _line);
            rbuf = rbuf.substr(1, n-1);
            if (!group_start(rbuf.c_str()))
                return false;  // _err should be set by group_start
        }
        else if ( (n=rbuf.find('=')) != -1)
        {
            // Parameter
            if (n == 0)
                return errmsg("File: %s, Line: %d - Invalid syntax (parameter name).",
                              _fname, _line);

            int n1 = rbuf.find_last_not_of(" \t", n-1);
            if (n1 == 0)
                return errmsg("File: %s, Line: %d - Invalid syntax (parameter name).",
                              _fname, _line);
            int n2 = rbuf.find_first_not_of(" \t", n+1);

            const char* p_val;
            if (n2 == -1) {
                return errmsg("File: %s, Line: %d - Invalid syntax (parameter value).",
                              _fname, _line);

                //p_val = "";
            } 
            else {
                p_val = rbuf.c_str() + n2;
            }
            if (!param_start(rbuf.substr(0, n1+1).c_str(), p_val))
                return false;  // _err should be set by param_start
        }
        else
            return errmsg("File: %s, Line: %d - Invalid syntax", _fname, _line);
    }

    return true;
} // IniFile::parse
